package TestClasses;
/**
 * @author student
 *
 * Class Information:
 * Class : EmailValidation.java
 * Package : TestClasses
 * Project: CoffeePurchasingApplication
 * This class is being used for testing a particular method for validation
 * of email addresses.
 * 
 */
class EmailValidation {
	
	/**
	 * This method is being used for testing whether a given email 
	 * address is valid.
	 * @param args arguments - takes one argument, the string to be
	 * validated. 
	 * @return void
	 */
	public static void main(String[] args) {
		String toTest = args[0];
		System.out.println(toTest);
		boolean success = isValidEmailAddress(toTest);
		System.out.println(toTest + " is a valid email address? " + success);
	}

	/**
	* Validates the structure of the Email Address. This method covers most 
	* requirements of the RFC822 specification.
	*
	* @param strEmailAddress Email Address to be validated
	* @return true if validation is successful, false otherwise
	*
	*/
	public static boolean isValidEmailAddress(String strEmailAddress) {

		boolean bValid = true;

		// return false if strEmailAddress is either null or empty
		if (isNullorEmpty(strEmailAddress)) {
			return false;
		}

		// calculate length of the email address
		int iLength = strEmailAddress.length();

		// get the first occurrence of @ char
		int iCharAtPosition = strEmailAddress.indexOf("@");

		// validation fails if @ character is not present 
		if (iCharAtPosition == -1) {
			System.out.println("1st");
			bValid = false;
		}
		// validation fails if @ character found is in the first or last position
		else if (
			(iCharAtPosition == 0) || (iCharAtPosition == (iLength - 1))) {
			System.out.println("2nd");
			bValid = false;
		}
		// validation fails if more than 1 @ character are present 
		else if (strEmailAddress.indexOf("@", iCharAtPosition + 1) > -1) {
			System.out.println("3rd");
			bValid = false;
		} else {

			// traverse thru all the characters in the given email address
			for (int i = 0; i < iLength; i++) {

				// get the character at the i position
				char c = strEmailAddress.charAt(i);
				System.out.println("4th c " + c);
				if (c == '.') {
					// validation fails if . character found is in the first or last position
					if ((i == 0) || (i == (iLength - 1))) {
						bValid = false;
						break;
					}
					// . character cannot come before @ character
					else if (i == (iCharAtPosition - 1)) {
						bValid = false;
						break;
					}
				}
				// all these are invalid characters
				else if (
					c > '~'
						|| c < '!'
						|| c == '('
						|| c == ')'
						|| c == '<'
						|| c == '>'
						|| c == '['
						|| c == ']'
						|| c == ','
						|| c == ';'
						|| c == ':'
						|| c == '\\'
						|| c == '"') {
					bValid = false;
					break;
				}
			}
		}
		// return the validation flag 
		return bValid;
	}
	
	/**
	 * This method is being used for checking whether the given string is
	 * null or empty.
	 * @param s The string to be checked.
	 * @return boolean Specifies whther the validation was successful.
	 */
	private static boolean isNullorEmpty(String s) {
		if (s == null || s.length() == 0) {
			return true;
		}
		return false;
	}
}
